//
// Simple Example of Parsing an XML File from a String
// and, if successful, printing the results.
//
// Usage: java ParseXMLFromString
//

import oracle.xml.parser.v2.*;
import java.io.*;
import java.net.*;
import org.w3c.dom.*;
import org.xml.sax.*;
 
public class ParseXMLFromString 
{
   public static void main( String[] arg ) throws IOException, SAXException 
   {
      // Create XML in a string
      String theStringToParse = "<?xml version='1.0'?><hello>world</hello>";
      XMLDocument theXMLDoc = parseString( theStringToParse );
      // Print the document out to standard out
      theXMLDoc.print(System.out);
   }

   public static XMLDocument parseString( String xmlString ) throws
      IOException, SAXException 
   {
      XMLDocument theXMLDoc     = null;
      // Create an oracle.xml.parser.v2.DOMParser to parse the document.
      DOMParser theParser = new DOMParser();
      // Open an input stream on the string
      ByteArrayInputStream theStream =
         new ByteArrayInputStream( xmlString.getBytes() );
      // Set the parser to work in non-Validating mode
      theParser.setValidationMode(DOMParser.NONVALIDATING);
      try 
      {
         // Parse the document from the InputStream
         theParser.parse( theStream );
         // Get the parsed XML Document from the parser
         theXMLDoc = theParser.getDocument();
      }
      catch (SAXParseException s) 
      {
         System.out.println(xmlError(s));
         throw s;
      }
      return theXMLDoc;
   }

   private static String xmlError(SAXParseException s) 
   {
      int lineNum = s.getLineNumber();
      int  colNum = s.getColumnNumber();
      String file = s.getSystemId();
      String  err = s.getMessage();
      return "XML parse error in file " + file +
         "\n" + "at line " + lineNum + ", character " + colNum +
         "\n" + err;
   }
}

